IF  NOT EXISTS (SELECT * FROM sys.objects 
					WHERE object_id = OBJECT_ID(N'[dbo].[EST_MOVIMENTO_VENDAS]') 
					AND type in (N'U')) 
BEGIN
CREATE TABLE [dbo].[EST_MOVIMENTO_VENDAS](
	[CD_CTR_VENDAS] [int] IDENTITY(1,1) NOT NULL,
	[CD_CTR_DT_MOVIMENTO] [int] NOT NULL,
	[CD_EMP] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[VLR_VD] [money] NOT NULL,
	[VLR_DESC_ITENS] [money] NOT NULL,
	[VLR_VD_LIQ] [money] NOT NULL,
	[QTDE_VD] [int] NOT NULL,
	[TIPO_VENDA] [int] NOT NULL,
	[DS_TIPO_VENDA] [varchar](150) NOT NULL,
	[VLR_PMC] [money] NOT NULL,
	[VLR_CUSTO_MD] [money] NOT NULL,
	[VLR_CUSTO_GER] [money] NOT NULL,
	[VLR_CUSTO] [money] NOT NULL,
	[VLR_DESC_OFERTA] [money] NOT NULL,
	[VLR_DESC_VERBA] [money] NOT NULL,
	[QTDE_ITENS] [money] NOT NULL,
	[VLR_DESC_RATEIO] [money] NOT NULL,
 CONSTRAINT [PK_EST_MOVIMENTO_VENDAS] PRIMARY KEY CLUSTERED 
(
	[CD_CTR_VENDAS] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY],
 CONSTRAINT [IX_EST_MOVIMENTO_VENDAS] UNIQUE NONCLUSTERED 
(
	[CD_CTR_DT_MOVIMENTO] ASC,
	[CD_FILIAL] ASC,
	[TIPO_VENDA] ASC,
	[CD_EMP] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]

ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_VLR_VD]  DEFAULT ((0)) FOR [VLR_VD]

ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_VLR_DESC_ITENS]  DEFAULT ((0)) FOR [VLR_DESC_ITENS]

ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_VLR_VD_LIQ]  DEFAULT ((0)) FOR [VLR_VD_LIQ]

ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_QTDE_VD]  DEFAULT ((0)) FOR [QTDE_VD]

ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_TIPO_VENDA]  DEFAULT ((0)) FOR [TIPO_VENDA]

ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_DS_TIPO_VENDA]  DEFAULT ((0)) FOR [DS_TIPO_VENDA]

ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_VLR_PMC]  DEFAULT ((0)) FOR [VLR_PMC]

ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_VLR_CUSTO_MD]  DEFAULT ((0)) FOR [VLR_CUSTO_MD]

ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_VLR_CUSTO_GER]  DEFAULT ((0)) FOR [VLR_CUSTO_GER]

ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_VLR_CUSTO]  DEFAULT ((0)) FOR [VLR_CUSTO]

ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_VLR_OFERTA]  DEFAULT ((0)) FOR [VLR_DESC_OFERTA]

ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_VLR_DESC_VERBA]  DEFAULT ((0)) FOR [VLR_DESC_VERBA]

ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_QTDE_ITENS]  DEFAULT ((0)) FOR [QTDE_ITENS]

ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_VLR_DESC_RATEIO]  DEFAULT ((0)) FOR [VLR_DESC_RATEIO]

ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS]  WITH CHECK ADD  CONSTRAINT [FK_EST_MOVIMENTO_VENDAS_GLB_DT_MOVIMENTO] FOREIGN KEY([CD_CTR_DT_MOVIMENTO])
REFERENCES [dbo].[GLB_DT_MOVIMENTO] ([CD_CTR_DT_MOVIMENTO])

ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS] CHECK CONSTRAINT [FK_EST_MOVIMENTO_VENDAS_GLB_DT_MOVIMENTO]
end